<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\checkout;

use app\common\exception\BaseException;
use app\common\model\users\UsersCart as UsersCartModel;
use app\common\service\Users as UsersService;

/**
 * @package app\api\service\checkout
 * @class Cart
 * @author xzncit 2024-03-14
 */
class Cart extends Goods {

    /**
     * @param $params
     * @param $address
     * @return UsersCartModel[]|array|\think\Collection
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getData($params,$address){
        $params["id"] = array_map("intval",explode(",",$params["id"]??[]));
        if(empty($params["id"])){
            throw new BaseException("请选择商品在下单",0);
        }

        $condition = [];
        $condition[] = ["user_id","=",UsersService::get("id",0)];
        $condition[] = ["id","in",$params["id"]];
        return [
            UsersCartModel::where($condition)->select()->map(function ($res)use($address){
                return self::getGoodsInfo([
                    "id"     => $res["goods_id"],
                    "sku_id" => $res["sku_id"],
                    "num"    => $res["goods_num"],
                ],$address);
            })->toArray(),
            ["promoter_id"=>0,"type"=>"goods"]
        ];
    }


}