<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service\checkout;

use app\common\model\goods\Distribution as DistributionModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\common\model\goods\Goods as GoodsModel;
use app\common\model\goods\GoodsItem as GoodsItemModel;
use app\common\model\goods\Spec as SpecModel;
use app\common\service\promotion\Discount as DiscountService;

/**
 * @package app\api\service\checkout
 * @class Goods
 * @author xzncit 2024-03-14
 */
class Buy {

    /**
     * 获取商品品数据
     * @param $params
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function getData($params,$address){
        $params["num"] = intval($params["num"]??0);
        if(empty($params["num"])){
            throw new BaseException("请选择需要购买的数量",0);
        }

        $result = self::getGoodsInfo($params,$address);
        return [
            [$result],
            [
                "promoter_id" => DiscountService::getItem("id"),
                "type"        => DiscountService::getItem("id") == 0 ? "goods" : "discount"
            ]
        ];
    }

    public static function getGoodsInfo($params,$address){
        $goods = GoodsModel::where("id",$params["id"]??0)->find();
        if(empty($goods)){
            throw new BaseException("请选择需要下单的商品",0);
        }

        if($goods["sku_type"] == 2 && empty($params["sku_id"])){
            throw new BaseException("请选择商品规格后在下单",0);
        }

        $discount = DiscountService::special($goods["sell_price"],$goods["id"]);
        $result = [
            "order_type"        => 1,
            "goods_id"          => $goods["id"],
            "sku_id"            => 0,
            "photo"             => Image::thumb($goods["photo"],["prefix"=>"medium"]),
            "goods_name"        => $goods["title"],
            "goods_number"      => $goods["goods_number"],
            "real_price"        => $discount["price"],
            "sell_price"        => $goods["sell_price"],
            "market_price"      => $goods["market_price"],
            "cost_price"        => $goods["cost_price"],
            "store_nums"        => $goods["store_nums"],
            "total_price"       => formatMoney($discount["price"] * $params["num"]),
            "goods_total_nums"  => $params["num"],
            "goods_weight"      => $goods["goods_weight"],
            "goods_array"       => ""
        ];

        if($goods["sku_type"] == 2){
            $goodsItem = GoodsItemModel::where(["goods_id"=>$goods["id"],"sku_id"=>$params["sku_id"]])->find();
            if(empty($goodsItem)){
                throw new BaseException("您选中的商品已售完",0);
            }

            $discount = DiscountService::special($goods["sell_price"],$goods["id"]);
            $result["sku_id"]        = $params["sku_id"];
            $result["real_price"]    = $goodsItem["sell_price"];
            $result["sell_price"]    = $discount["price"];
            $result["market_price"]  = $goodsItem["market_price"];
            $result["cost_price"]    = $goodsItem["cost_price"];
            $result["goods_weight"]  = $goodsItem["goods_weight"];
            $result["store_nums"]    = $goodsItem["store_nums"];
            $result["total_price"]   = formatMoney($discount["price"] * $params["num"]);
            $result["goods_array"] = [
                "name"      => SpecModel::getSpecInfo($goodsItem["spec_value"]),
                "value"     => $goodsItem["spec_value"]
            ];

            $goods["goods_weight"] = $goodsItem["goods_weight"];
        }

        $result["real_freight"] = DistributionModel::getFreightPrice($goods,$params["num"],$address);
        return $result;
    }

}