<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use app\common\facade\Sms as SmsUtils;
use app\common\enum\Sms as SmsEnum;
use app\common\library\jwt\Token;
use app\common\model\Users as UsersModel;

/**
 * @package app\api\service
 * @class Sms
 * @author xzncit 2024-01-25
 */
class Sms {

    /**
     * 发送短信
     * @param array $value
     * @return null
     * @throws \Exception
     */
    public static function sendSMS($value=[]){
        $scene = SmsEnum::getType($value["scene"]);
        if(empty($scene)){
            throw new \Exception("获取场景值失败",0);
        }

        // 找回密码,手机登录
        if(in_array($scene,[SmsEnum::USER_PASSWORD,SmsEnum::USER_LOGIN])){
            $user = UsersModel::where("mobile",$value["mobile"])->find();
            if(empty($user)){
                throw new \Exception("您要找回密码的用户手机号不存在",0);
            }
        }else if(in_array($scene,[SmsEnum::USER_BIND,SmsEnum::USER_CHANGE])){ // 检查用户是否登录
            $user = UsersModel::where("id",Token::get("id",0))->find();
            if(empty($user)){
                throw new \Exception("您还未登录，不允许执行绑定手机操作",0);
            }

            if(UsersModel::where("mobile",$value["mobile"])->count()){
                throw new \Exception("申请绑定的手机号已被其他帐号绑定");
            }
        }

        SmsUtils::send($scene,$value["mobile"]);
        return null;
    }

}