<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use app\common\model\Archives as ArchivesModel;
use app\common\service\Config as ConfigService;
use app\common\library\utils\Image;
use app\common\exception\BaseException;

/**
 * @package app\api\service
 * @class Search
 * @author xzncit 2024-02-10
 */
class Search {

    /**
     * 获取搜索内容
     * @param array $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getSearchContent($params=[]){
        $keyword = [];
        if(!empty($params["wd"])){
            $arr = explode(" ",$params["wd"]);
            foreach($arr as $item){
                $keyword[] = "%".$item."%";
            }
        }

        $array  = [];
        $result = ArchivesModel::where("title","like",$keyword,"OR")->where("status",1)->select()->toArray();
        foreach($result as $value){
            $array[] = $value["title"];
        }

        return $array;
    }

    /**
     * 获取关键字
     * @return array
     */
    public static function getKeywords(){
        $keywords = ConfigService::getString("keywords");
        if(empty($keywords)){
            return [];
        }

        $array = explode("|",$keywords);
        return array_map("trim",$array);
    }

    /**
     * 获取搜索内容
     * @param array $params
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $condition = [];
        if(!empty($params["keyword"])){
            $arr = explode(" ",urldecode($params["keyword"]));
            foreach($arr as $item){
                $condition[] = ["title","like","%".$item."%"];
            }
        }

        $array = [
            "total" => 0,
            "list"  => [],
            "size"  => 10
        ];

        $page  = $params["page"]??1;
        $count = ArchivesModel::whereOr($condition)->count();
        $array["list"] = ArchivesModel::whereOr($condition)->page($page,$array["size"])->select()->map(function ($res){
            return [
                "name"  => $res["title"],
                "image" => Image::thumb($res["photo"]),
                "link"  => [
                    "path" => "/pages/archives/view?id=" . $res['id']
                ]
            ];
        });

        $array["total"] = ceil($count / $array["size"]);
        if($array["total"] == $page -1){
            throw new BaseException("没有数据了哦！",-1,$array);
        }

        return $array;
    }

}