<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use app\common\model\Region as RegionModel;

/**
 * @package app\api\service
 * @class Region
 * @author xzncit 2024-03-03
 */
class Region {

    /**
     * 获取地区信息
     * @param array $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $pid   = intval($params["pid"]??0);
        $condition = [];
        $condition[] = ["pid","=",$pid];
        $result = RegionModel::where($condition)->select()->toArray();
        
        $array = [];
        foreach($result as $key=>$item){
            $array[] = [
                'value' => $item["id"],
                'label' => $item["name"],
                'level' => $item["level"]
            ];
        }

        return $array;
    }

}