<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use app\common\library\utils\Image;
use app\common\service\Config;
use app\common\service\diy\Setting as LayoutSettingService;
use app\common\service\Config as ConfigService;
use think\facade\Request;

/**
 * @package app\api\service
 * @class Common
 * @author xzncit 2024-01-15
 */
class Common {

    /**
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function initialize(){
        $array = [];
        $color = LayoutSettingService::get("color",[]);

        if(!empty($color["options"])){
            $array["theme"] = $color["id"];
        }

        $tabbar = LayoutSettingService::get("tabbar",[]);
        if(!empty($tabbar)){
            $list = [];
            $index = 0;
            foreach($tabbar["list"] as $value){
                $value["index"]         = $index++;
                $value["image"]         = Image::thumb($value["image"]);
                $value["selectedImage"] = Image::thumb($value["selectedImage"]);
                $list[]                 = $value;
            }

            $array["tabbar"] = [
                "type"              => $tabbar["type"],
                "color"             => $tabbar["color"],
                "selectedColor"     => $tabbar["selectedColor"],
                "borderStyle"       => $tabbar["borderStyle"],
                "backgroundColor"   => $tabbar["backgroundColor"],
                "list"              => $list
            ];
        }

        $clientType = Request::header("Client-Type","h5");
        $array["site"]["status"] = 1;
        if($clientType == "mp-weixin"){
            $array["site"]["name"] = ConfigService::getArray("miniprogram.name","");
        }else{
            $array["site"]["name"] = ConfigService::getArray("wechat.name","");
        }

        $array["site"] = array_merge($array["site"],ConfigService::getArray("users",[]));
        $array["site"]["avatar"] = Image::avatar($array["site"]["avatar"]??null);
        return $array;
    }

    /**
     * 获取协议信息
     * @param $type
     * @return array|mixed|null
     */
    public static function getAgree($type){
        return ConfigService::getArray($type,["title"=>"","content"=>""]);
    }

}