<?php

namespace app\api\service;

use app\common\library\utils\Image;
use app\common\model\Category as CategoryModel;
use app\common\library\utils\Data;

/**
 * @package app\api\service
 * @class Category
 * @author xzncit 2024/3/19
 */
class Category {

    /**
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList(){
        $result = CategoryModel::where(["module"=>"goods","status"=>1,"is_menu"=>1])->select()->map(function ($res){
            $photo = Image::thumb($res["photo"]);
            return [
                "id"    => $res["id"],
                "pid"   => $res["pid"],
                "title" => $res["title"],
                "photo" => $photo
            ];
        });

        $array = Data::familyProcess($result);
        return array_values($array);
    }

}