<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use think\facade\Request;
use app\common\model\order\Order as OrderModel;
use app\common\enum\Terminal;
use app\api\model\PaymentTerminal as PaymentTerminalModel;
use app\common\library\utils\Image;
use app\common\service\Users as UsersService;
use app\common\service\payment\Payment as PaymentService;
use app\common\model\order\Recharge as RechargeModel;

/**
 * @package app\api\service
 * @class Cashier
 * @author xzncit 2024-03-13
 */
class Cashier {

    public static function order($params=[]){
        if(!empty($params["pay_type"]) && $params["pay_type"] == "order"){
            return OrderModel::where("id",$params["order_id"]??0)->value("order_amount",0.00);
        }else{
            return RechargeModel::where("id",$params["order_id"]??0)->value("pay_price",0.00);
        }
    }

    public static function payment($params=[]){
        $data = ["order_id"=>$params["order_id"]??0,"pay_id"=>$params["pay_id"]??0];
        if(!empty($params["pay_type"]) && $params["pay_type"] == "order"){
            return PaymentService::order($data);
        }else{
            return PaymentService::recharge($data);
        }
    }

    /**
     * 获取支付方式
     * @return PaymentTerminalModel[]|array|\think\Collection
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getPaymentList($params){
        $type = Terminal::getTerminalNo(Request::header("Client-Type","h5"));
        $condition = [];
        $condition[] = ["terminal","=",$type];
        $condition[] = ["payment_terminal.status","=",1];
        $condition[] = ["payment.status","=",1];
        $condition[] = ["payment.code","<>","bank"];
        if($params["pay_type"] == "recharge"){
            $condition[] = ["payment.code","<>","balance"];
        }
        return PaymentTerminalModel::withJoin("payment")->where($condition)->order('payment.sort','ASC')->select()->map(function ($value){
            $payment = $value["payment"];
            return [
                "id"        => $payment["id"],
                "name"      => $payment["alias_name"],
                "icon"      => Image::thumb($payment["photo"]),
                "money"     => ($payment["code"] == "balance" ? UsersService::get("money",'0.00') : 0),
                "checked"   => ($value["is_default"] == 1)
            ];
        });
    }

}