<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\service;

use app\common\model\Archives as ArchivesModel;
use app\common\model\Admin as AdminModel;
use think\facade\Db;

/**
 * @package app\api\service
 * @class Archives
 * @author xzncit 2024-02-06
 */
class Archives {

    /**
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = ArchivesModel::where(["id"=>$id,"status"=>1])->find();
        if(empty($row)){
            throw new \Exception("您要访问的内容不存在",0);
        }

        ArchivesModel::where(["id"=>$id,"status"=>1])->save([ "hits"=>Db::raw("hits+1") ]);

        return [
            "id"            => $row["id"],
            "author_name"   => AdminModel::where("id",$row["author_id"])->value("nickname","-"),
            "title"         => $row["title"],
            "intro"         => $row["intro"],
            "content"       => $row["content"],
            "hits"          => $row["hits"],
            "create_time"   => date("Y-m-d H:i:s",$row["create_time"])
        ];
    }

}