<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\model\users;

use app\common\model\promotion\Coupon as CouponModel;
use app\common\model\users\UsersCoupon as UsersCouponModel;

/**
 * @package app\api\model\users
 * @class Coupon
 * @author xzncit 2024-03-04
 */
class UsersCoupon extends UsersCouponModel {

    /**
     * 增加查询条件
     * @param $query
     * @param $value
     * @param $data
     */
    public function searchActiveAttr($query, $value, $data){
        switch($value){
            case 0:
                $query->where("users_coupon.status","=","0");
                $query->where("users_coupon.end_time > " . time());
                break;
            case 1:
                $query->where("users_coupon.status","=","1");
                break;
            case 2:
                $query->where("users_coupon.status","=","0");
                $query->where(time() . " >= users_coupon.end_time");
                break;
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function coupon(){
        return $this->hasOne(CouponModel::class,'id','coupon_id');
    }

}