<?php

namespace app\api\model\order;

use app\common\model\order\Order as OrderModel;
use app\common\model\order\OrderRefunds as OrderRefundsModel;

/**
 * @package app\api\model\order
 * @class OrderRefunds
 * @author xzncit 2024/3/21
 */
class OrderRefunds extends OrderRefundsModel {

    public function searchTypeAttr($query, $value, $data){
        switch($value){
            case "verify":
                $query->where("order_refunds.audit_status","=","1");
                break;
            case "agree":
                $query->where("order_refunds.audit_status","=","2");
                break;
            case "refuse":
                $query->where("order_refunds.audit_status","=","3");
                break;
        }
    }

    /**
     * 关联表
     * @return \think\model\relation\HasOne
     */
    public function orders(){
        return $this->hasOne(OrderModel::class,'id','order_id');
    }

}