<?php

namespace app\api\model\order;

use app\common\model\order\Order as OrderModel;

/**
 * @package app\api\model\order
 * @class Order
 * @author xzncit 2024/3/18
 */
class Order extends OrderModel {

    public function searchTypeAttr($query, $value, $data){
        switch($value){
            case "payment":
                $query->where("status","in","1,2");
                $query->where("pay_status","=","1");
                break;
            case "delivery":
                $query->where("status","=","3");
                $query->where("delivery_status","=",1);
                break;
            case "received":
                $query->where("status","in","4,5");
                $query->where("collect_status","=",1);
                break;
            case "evaluate":
                $query->where("status","=",6);
                $query->where("refund_status","=",1);
                $query->where("evaluate_status","in","1,3");
                $query->where("collect_status","=",2);
                break;
        }
    }

}