<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller\wechat;

use app\Controller;
use think\facade\Request;
use app\common\service\wechat\Auth as AuthService;

/**
 * @package app\api\controller\wechat
 * @class Auth
 * @author xzncit 2024-01-29
 */
class Auth extends Controller {

    /**
     * 登录
     * @return \think\response\Json
     * @throws \Exception
     */
    public function login(){
        return returnAjax("msg:ok",1,AuthService::login(Request::param()));
    }

    /**
     * 获取公众号信息
     * @return \think\response\Json
     */
    public function config(){
        return returnAjax("msg:ok",1,AuthService::config());
    }

}