<?php

namespace app\api\controller\ucenter;

use think\facade\Request;
use app\api\controller\Controller;
use app\api\service\ucenter\Withdraw as WithdrawService;

/**
 * @package app\api\controller\ucenter
 * @class Withdraw
 * @author xzncit 2024/4/14
 */
class Withdraw extends Controller {

    /**
     * 提现配置
     * @return \think\response\Json|void
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        if(Request::isGet()){
            return returnAjax("msg:ok",1,[
                "config"    => WithdrawService::getConfig(),
                "payment"   => WithdrawService::getPaymentList()
            ]);
        }

        return returnAjax("msg:ok",1,WithdrawService::order(Request::param()));
    }

    /**
     * 获取提现配置
     * @return \think\response\Json
     */
    public function bank(){
        return returnAjax("msg:ok",1,WithdrawService::getBank(Request::param()));
    }

    /**
     * 保存提现配置
     * @return \think\response\Json
     */
    public function save(){
        return returnAjax("msg:ok",1,WithdrawService::save(Request::param()));
    }

    /**
     * 金额日志
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function wallet(){
        return returnAjax("msg:ok",1,WithdrawService::wallet(Request::param()));
    }

    /**
     * 提现记录
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function log(){
        return returnAjax("msg:ok",1,WithdrawService::getLog(Request::param()));
    }

}