<?php

namespace app\api\controller\ucenter;

use app\api\controller\Controller;
use app\api\service\ucenter\Recharge as RechargeService;
use app\common\service\Config;
use think\facade\Request;

/**
 * @package app\api\controller\ucenter
 * @class Recharge
 * @author xzncit 2024/3/17
 */
class Recharge extends Controller {

    /**
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,Config::getArray("recharge.status",0));
    }

    /**
     * @return \think\response\Json
     */
    public function wallet(){
        return returnAjax("msg:ok",1,Config::getArray("recharge"));
    }

    public function pay(){
        return returnAjax("msg:ok",1,RechargeService::pay(Request::param()));
    }

    public function log(){
        return returnAjax("msg:ok",1,RechargeService::log(Request::param()));
    }

}