<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller\ucenter;

use think\facade\Request;
use app\api\controller\Controller;
use app\api\service\ucenter\Invoice as InvoiceService;
use app\api\validate\ucenter\Invoice as InvoiceValidate;

/**
 * @package app\api\controller\ucenter
 * @class Invoice
 * @author xzncit 2024-03-13
 */
class Invoice extends Controller {

    public function index(){
        return returnAjax("msg:ok",1,InvoiceService::getList());
    }

    public function detail(){
        return returnAjax("msg:ok",1,InvoiceService::detail(Request::param("id",0,"intval")));
    }

    public function editor(){
        $data = Request::param();
        validate(InvoiceValidate::class)->check($data);
        InvoiceService::save($data);
        return returnAjax("msg:ok",1);
    }

    public function delete(){
        InvoiceService::delete(Request::param("id",0,"intval"));
        return returnAjax("msg:ok",1);
    }

}