<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller\ucenter;

use think\facade\Request;
use app\api\controller\Controller;
use app\api\service\ucenter\Address as AddressService;
use app\api\validate\ucenter\Address as AddressValidate;

class Address extends Controller {

    public function index(){
        return returnAjax("msg:ok",1,AddressService::getList());
    }

    public function detail(){
        return returnAjax("msg:ok",1,AddressService::detail(Request::param("id",0,"intval")));
    }

    public function editor(){
        $data = Request::param();
        validate(AddressValidate::class)->check($data);
        AddressService::save($data);
        return returnAjax("msg:ok",1);
    }

    public function status(){
        $data = Request::param();
        AddressService::status($data);
        return returnAjax("msg:ok",1);
    }

    public function delete(){
        AddressService::delete(Request::param("id",0,"intval"));
        return returnAjax("msg:ok",1);
    }

}