<?php

namespace app\api\controller\service;

use app\api\controller\Controller;
use think\facade\Request;
use app\api\service\chat\Service;

/**
 * @package app\api\controller\service
 * @class Index
 * @author xzncit 2024/3/31
 */
class Index extends Controller {

    /**
     * @return \think\response\Json
     */
    public function index(){
        return returnAjax("msg:ok",1,Service::config(Request::param()));
    }

    /**
     * 人工客服
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function customer(){
        return returnAjax("msg:ok",1,Service::customer());
    }

    /**
     * 客服列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function service_list(){
        return returnAjax("msg:ok",1,Service::getServiceList(Request::param()));
    }

    /**
     * 消息列表
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function message_list(){
        return returnAjax("msg:ok",1,Service::getMessageList(Request::param()));
    }

    /**
     * 发送消息
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function send(){
        Service::send(Request::param());
        return returnAjax("msg:ok",1);
    }

    /**
     * 上传图片
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function upload(){
        Service::upload();
        return returnAjax("msg:ok",1);
    }

    public function update_message_status(){
        Service::updateMessageStatus();
        return returnAjax("msg:ok",1);
    }

}