<?php

namespace app\api\controller\order;

use app\api\controller\Controller;
use app\api\service\order\Order as OrderService;
use think\facade\Request;

/**
 * @package app\api\controller\order
 * @class Index
 * @author xzncit 2024/3/18
 */
class Index extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,OrderService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function detail(){
        return returnAjax("msg:ok",1,OrderService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 确认收货
     * @return \think\response\Json
     */
    public function delivery(){
        return returnAjax("msg:ok",1,OrderService::delivery(Request::param("id",0,"intval")));
    }

    /**
     * 取消订单
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function cancel(){
        return returnAjax("msg:ok",1,OrderService::cancel(Request::param("id",0,"intval")));
    }

    /**
     * 物流信息
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function express(){
        return returnAjax("msg:ok",1,OrderService::express(Request::param("id",0,"intval")));
    }

}