<?php

namespace app\api\controller\order;

use app\api\controller\Controller;
use think\facade\Request;
use app\api\service\order\Comment as CommentService;

/**
 * @package app\api\controller\order
 * @class Comment
 * @author xzncit 2024/3/20
 */
class Comment extends Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function index(){
        return returnAjax("msg:ok",1,CommentService::getList(Request::param("order_id",0,"intval")));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function detail(){
        return returnAjax("msg:ok",1,CommentService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 保存评论
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function save(){
        return returnAjax("msg:ok",1,CommentService::save(Request::param()));
    }

    /**
     * 上传图片
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function upload(){
        return returnAjax("msg:ok",1,CommentService::upload(Request::param("id",0,"intval")));
    }

}