<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller\goods;

use app\api\service\goods\Goods as GoodsService;
use think\facade\Request;

/**
 * @package app\api\controller\goods
 * @class Index
 * @author xzncit 2024-03-07
 */
class Index extends \app\Controller {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,GoodsService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function detail(){
        return returnAjax("msg:ok",1,GoodsService::detail(Request::param("id",0,"intval")));
    }

    /**
     * 收藏商品
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function collect(){
        return returnAjax("msg:ok",1,GoodsService::collect(Request::param("id",0,"intval")));
    }

    /**
     * 优惠券
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function coupon(){
        return returnAjax("msg:ok",1,GoodsService::coupon());
    }

    /**
     * 商品推荐
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function recommend(){
        return returnAjax("msg:ok",1,GoodsService::recommend(Request::param()));
    }

}