<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use app\common\enum\Sms as SmsEnum;
use think\facade\Request;
use app\api\service\User as UserService;
use app\api\validate\Register as RegisterValidate;
use app\api\validate\Login as LoginValidate;
use app\api\validate\Forget as ForgetValidate;
use app\api\validate\Bind as BindValidate;
use app\api\validate\Password as PasswordValidate;

/**
 * @package app\api\controller
 * @class User
 * @author xzncit 2024-01-23
 */
class User extends \app\Controller {

    protected $middleware = [
        'auth'=>['only'=>['password','field','avatar']]
    ];

    /**
     * 会员注册
     * @return \think\response\Json
     */
    public function register(){
        $params = Request::param();
        validate(RegisterValidate::class)->check($params);
        return returnAjax("msg:ok",1,UserService::register($params));
    }

    /**
     * 会员登录
     * @return \think\response\Json
     * @throws \Exception
     */
    public function login(){
        $params = Request::param();
        validate(LoginValidate::class)->scene($params["scene"]??"user")->check($params);
        return returnAjax("msg:ok",1,UserService::login($params));
    }

    /**
     * 找回密码
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function forget(){
        $params = Request::param();
        validate(ForgetValidate::class)->check($params);
        return returnAjax("修改密码成功",1,UserService::forget($params));
    }

    /**
     * 绑定手机
     * @return \think\response\Json
     */
    public function bind(){
        $params = Request::param();
        validate(BindValidate::class)->check($params);
        return returnAjax("绑定手机成功",1,UserService::bind($params,SmsEnum::USER_BIND));
    }

    /**
     * 变更手机
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function change(){
        $params = Request::param();
        validate(BindValidate::class)->check($params);
        return returnAjax("绑定手机成功",1,UserService::bind($params,SmsEnum::USER_CHANGE));
    }

    /**
     * 修改密码
     * @return \think\response\Json
     * @throws \Exception
     */
    public function password(){
        $params = Request::param();
        validate(PasswordValidate::class)->check($params);
        return returnAjax("修改密码成功",1,UserService::password($params));
    }

    /**
     * 会员信息
     * @return \think\response\Json
     */
    public function center(){
        return returnAjax("msg:ok",1,UserService::center());
    }

    /**
     * 更新会员信息
     * @return \think\response\Json
     */
    public function field(){
        return returnAjax("msg:ok",1,UserService::field(Request::param()));
    }

    /**
     * 上传头像
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function avatar(){
        return returnAjax("msg:ok",1,UserService::avatar());
    }

}