<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use app\api\service\Search as SearchService;
use think\facade\Request;

/**
 * @package app\api\controller
 * @class Search
 * @author xzncit 2024-02-10
 */
class Search extends \app\Controller {

    /**
     * 获取关键字
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,SearchService::getSearchContent(Request::param()));
    }

    public function keywords(){
        return returnAjax("msg:ok",1,SearchService::getKeywords());
    }

    public function lists(){
        return returnAjax("msg:ok",1,SearchService::getList(Request::param()));
    }

}