<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use think\facade\Request;
use app\api\service\promotion\Coupon as CouponService;

/**
 * @package app\api\controller
 * @class Coupon
 * @author xzncit 2024-03-04
 */
class Coupon extends Controller {

    protected $middleware = [
        'auth'=>['only'=>['receive']]
    ];

    /**
     * 列表
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,CouponService::getList(Request::param()));
    }

    /**
     * 领券
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function receive(){
        CouponService::receive(Request::param("id",0,"intval"));
        return returnAjax("msg:ok",1);
    }

}