<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use think\facade\Request;
use app\common\library\utils\QrCode;
use app\api\service\Common as CommonService;

/**
 * @package app\api\controller
 * @class Common
 * @author xzncit 2024-01-15
 */
class Common extends \app\Controller {

    /**
     * @return \think\response\Json
     */
    public function init(){
        return returnAjax("msg:ok",1,CommonService::initialize());
    }

    /**
     * 二维码
     */
    public function qrcode(){
        $url = Request::domain() . '/mobile?u=' . Request::param("id",0,"intval");
        return QrCode::create($url);
    }

    /**
     * @return \think\response\Json
     */
    public function agree(){
        return returnAjax("msg:ok",1,CommonService::getAgree(Request::param("type","","trim,strip_tags")));
    }

}