<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use app\api\service\Checkout as CheckoutService;
use think\facade\Request;

/**
 * @package app\api\controller
 * @class Checkout
 * @author xzncit 2024-03-14
 */
class Checkout extends Controller {

    /**
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,CheckoutService::detail(Request::param()));
    }

    /**
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function create(){
        return returnAjax("msg:ok",1,CheckoutService::create(Request::param()));
    }

    /**
     * 地址
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function address(){
        return returnAjax("msg:ok",1,CheckoutService::address());
    }

    /**
     * 开票
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function invoice(){
        return returnAjax("msg:ok",1,CheckoutService::invoice());
    }

}