<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use app\api\service\Cart as CartService;
use think\facade\Request;

/**
 * @package app\api\controller
 * @class Cart
 * @author xzncit 2024-03-12
 */
class Cart extends Controller {

    protected $middleware = [
        'auth'=>['except'=>['index','count']]
    ];

    public function index(){
        return returnAjax("msg:ok",1,CartService::getList(Request::param()));
    }

    /**
     * 添加商品
     * @return \think\response\Json
     */
    public function add(){
        CartService::add(Request::param());
        return returnAjax("msg:ok",1);
    }

    public function update(){
        return returnAjax("msg:ok",1,CartService::update(Request::param()));
    }

    /**
     * 购物车商品总数量
     * @return \think\response\Json
     * @throws \app\common\exception\BaseException
     */
    public function count(){
        return returnAjax("msg:ok",1,CartService::count());
    }

    /**
     * 商品总数
     * @return \think\response\Json
     */
    public function total(){
        return returnAjax("msg:ok",1,CartService::total());
    }

    /**
     * 删除
     * @return \think\response\Json
     * @throws \Exception
     */
    public function delete(){
        return returnAjax("msg:ok",1,CartService::delete(Request::param()));
    }

}