<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\api\controller;

use app\api\service\Archives as ArchivesService;
use app\api\service\Search as SearchService;
use think\facade\Request;

/**
 * @package app\api\controller
 * @class Archives
 * @author xzncit 2024-02-06
 */
class Archives {

    /**
     * 列表
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function index(){
        return returnAjax("msg:ok",1,SearchService::getList(Request::param()));
    }

    /**
     * 详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail(){
        return returnAjax("msg:ok",1,ArchivesService::detail(Request::param("id",0,"intval")));
    }

}