<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\validate;

use think\Validate;

/**
 * @package app\adminapi\validate
 * @class DistributionValidate
 * @author xzncit 2024-02-19
 */
class DistributionValidate extends Validate {

    protected $rule =   [
        'title'                => 'require|min:2|max:15',
        'first_weight'         => 'require|float',
        'first_price'          => 'require|float',
        'second_weight'        => 'require|float',
        'second_price'         => 'require|float'
    ];

    protected $message  =   [
        'title.require'            => '请输入发货点名称',
        'title.min'                => '发货点名称长度至少2个字符',
        'title.max'                => '发货点名称不能超过15个字符',
        'first_weight.require'     => '请选择首重重量',
        'first_weight.float'       => '您填写的首重重量内容不合法',
        'first_price.require'      => '请输入首重费用',
        'first_price.float'        => '您填写的首重费用内容不合法',
        'second_weight.require'    => '请输入续重重量',
        'second_weight.float'      => '您填写的续重重量内容不合法',
        'second_price.require'     => '请输入续重费用',
        'second_price.float'       => '您填写的续重费用内容不合法'
    ];

}