<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\wechat;

use app\adminapi\model\WechatAccountReply as WechatAccountReplyModel;

/**
 * @package app\adminapi\service\wechat
 * @class Reply
 * @author xzncit 2024-02-01
 */
class Reply {

    /**
     * 列表
     * @param array $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $array           = [];
        $fields          = [["title","active"],["title"=>$params["keywords"]??'',"active"=>$params["active"]??0]];
        $array["total"]  = WechatAccountReplyModel::withSearch(...$fields)->count();
        $result          = WechatAccountReplyModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key] = $value;
        }

        $array["count"] = [
            "0" => WechatAccountReplyModel::count(),
            "1" => WechatAccountReplyModel::where(["type"=>1])->count(),
            "2" => WechatAccountReplyModel::where(["type"=>2])->count(),
            "3" => WechatAccountReplyModel::where(["type"=>3])->count()
        ];

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array = WechatAccountReplyModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        return $array;
    }

    /**
     * 保存
     * @param array $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params=[]){
        if(!empty($params["id"]) && WechatAccountReplyModel::where("id",$params["id"])->find()){
            $params["update_time"] = time();
            WechatAccountReplyModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            $params["update_time"] = time();
            WechatAccountReplyModel::create($params);
        }

        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        $condition = [];
        if(is_array($id)){
            $condition[] = ["id","in",$id];
        }else{
            $condition[] = ["id","=",$id];
        }

        return WechatAccountReplyModel::where($condition)->delete();
    }

}