<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\shop;

use app\common\model\Region as RegionModel;
use app\common\library\utils\Data;

/**
 * @package app\adminapi\service\shop
 * @class Region
 * @author xzncit 2024-02-14
 */
class Region {

    /**
     * 列表
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($id=0){
        $data = RegionModel::where("pid",$id)->order('id','asc')->select()->toArray();
        return array_map(function ($res){
            $res["hasChildren"] = RegionModel::where("pid",$res["id"])->count() ? true : false;
            return $res;
        },$data);
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = RegionModel::where("id",$id)->find();

        $array = [];
        if(!empty($row)){
            $array["name"]  = $row["name"];
            $array["pid"]   = array_map(function ($num){ return (int)$num; },array_reverse(RegionModel::getParents($row["pid"])));
            $array["sort"]  = $row["sort"];
            $array["id"]    = $row["id"];
        }

        return $array;
    }

    /**
     * 保存
     * @param $data
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($data){
        if(empty($data["pid"])){
            $data["pid"] = [];
        }

        $data["level"]  = count($data["pid"]) + 1;
        $data["pid"]    = empty($data["pid"]) ? 0 : end($data["pid"]);

        if(!empty($data["id"]) && $res = RegionModel::where("id",$data["id"])->find()){
            if(!Data::checkTree(RegionModel::select()->toArray(),$data)){
                throw new \Exception("{$data['name']} 是 ID {$data['pid']} 的父栏目,不能修改！",0);
            }

            if($res["id"] == $data["pid"]){
                throw new \Exception("不允许选择上一级作为分类",0);
            }

            RegionModel::where("id",$data["id"])->save($data);
        }else{
            RegionModel::create($data);
        }


        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        $array   = RegionModel::getChildren($id);
        $array[] = $id;
        return RegionModel::where("id","in",$array)->delete();
    }

}