<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\shop;

use app\adminapi\model\shop\Distribution as DistributionModel;
use app\common\exception\BaseException;
use app\common\library\utils\Data;
use app\common\model\Region as RegionModel;

/**
 * @package app\adminapi\service\shop
 * @class Distribution
 * @author xzncit 2024-02-14
 */
class Distribution {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = DistributionModel::withSearch(...$fields)->count();
        $array["list"]   = DistributionModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $condition = [];
        $condition[] = ["id","=",$id];
        $row = DistributionModel::where($condition)->find();

        $row["area"] = [];
        if(!empty($row["area_group"])){
            $row["area_group_id"] = json_decode($row["area_group"],true);
            $area_group_id = [];

            foreach($row["area_group_id"] as $key=>$value){
                foreach($value as $k=>$v){
                    $area_group_id[] = $v;
                }
            }

            $row["area_group"] = implode(",",$area_group_id);
            $result = RegionModel::where("id","in",$area_group_id)->select()->toArray();
            $row["area"] = Data::familyProcess($result);
        }else{
            $row["area_group"] = '';
            $row["area_group_id"] = [];
        }

        if(!empty($row["first_price_group"])){
            $row["first_price_group"] = json_decode($row["first_price_group"],true);
        }else{
            $row["first_price_group"] = [];
        }

        if(!empty($row["second_price_group"])){
            $row["second_price_group"] = json_decode($row["second_price_group"],true);
        }else{
            $row["second_price_group"] = [];
        }

        return $row;
    }

    /**
     * 保存
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        $row = DistributionModel::where("id",$params["id"])->find();
        if(!empty($row) && $row["is_lock"]){
            throw new \Exception("您编辑的内容不允许修改",0);
        }

        $params["area_group"]         = json_encode($params["area_group_id"],JSON_UNESCAPED_UNICODE);
        $params["first_price_group"]  = json_encode($params["first_price_group"],JSON_UNESCAPED_UNICODE);
        $params["second_price_group"] = json_encode($params["second_price_group"],JSON_UNESCAPED_UNICODE);

        if(!empty($params["id"]) && !empty($row)){
            DistributionModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            DistributionModel::create($params);
        }

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        DistributionModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return DistributionModel::where("id",$id)->delete();
    }

}