<?php

namespace app\adminapi\service\shop;

use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\adminapi\model\users\UsersConsult as UsersConsultModel;

/**
 * @package app\adminapi\service\shop
 * @class Consult
 * @author xzncit 2024/3/21
 */
class Consult {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = UsersConsultModel::withSearch(...$fields)->withJoin("goods")->count();
        $array["list"]   = UsersConsultModel::withSearch(...$fields)->withJoin("goods")->order("users_consult.id","desc")->page($params["current"]??1,$params["size"]??10)->select()->map(function ($res){
            $goods = $res["goods"];

            return [
                "id"            => $res["id"],
                "user_id"       => $res["user_id"],
                "username"      => getUserName($res["user_id"]),
                "title"         => $goods["title"],
                "sell_price"    => $goods["sell_price"],
                "photo"         => Image::thumb($goods["photo"]),
                "status"        => $res["status"],
                "create_time"   => $res["create_time"],
            ];
        });

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $comments = UsersConsultModel::where("id",$id)->findOrEmpty()->toArray();
        if(empty($comments)){
            throw new BaseException("您要查看的商品咨询不存在",0);
        }

        return $comments;
    }

    /**
     * 保存
     * @param $params
     * @return true
     * @throws BaseException
     */
    public static function save($params=[]){
        $comments = UsersConsultModel::where("id",$params["id"]??0)->findOrEmpty()->toArray();
        if(empty($comments)){
            throw new BaseException("您要查看的商品咨询不存在",0);
        }

        if(empty($params["reply_content"])){
            throw new BaseException("请填写回复内容",0);
        }

        UsersConsultModel::where("id",$params["id"])->save([
            "reply_content" => $params["reply_content"],
            "status"        => 1,
            "reply_time"    => time()
        ]);

        return true;
    }

    /**
     * 删除评论
     * @param $id
     * @return true
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function delete($id){
        $comments = UsersConsultModel::where("id",$id)->find();
        if(empty($comments)){
            throw new BaseException("您要删除的商品咨询不存在",0);
        }

        UsersConsultModel::where("id",$id)->delete();
        return true;
    }

}