<?php

namespace app\adminapi\service\shop;

use app\adminapi\model\users\UsersComment as UsersCommentModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;
use think\facade\Config;

/**
 * @package app\adminapi\service\shop
 * @class Comments
 * @author xzncit 2024/3/21
 */
class Comments {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params=[]){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = UsersCommentModel::withSearch(...$fields)->withJoin("goods")->count();
        $array["list"]   = UsersCommentModel::withSearch(...$fields)->withJoin("goods")->order("users_comment.id","desc")->page($params["current"]??1,$params["size"]??10)->select()->map(function ($res){
            $goods = $res["goods"];

            return [
                "id"            => $res["id"],
                "user_id"       => $res["user_id"],
                "username"      => getUserName($res["user_id"]),
                "title"         => $goods["title"],
                "spec_value"    => $res["spec_value"],
                "sell_price"    => $goods["sell_price"],
                "photo"         => Image::thumb($goods["photo"]),
                "status"        => $res["status"],
                "reply_status"  => $res["reply_status"],
                "create_time"   => $res["create_time"],
            ];
        });

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $comments = UsersCommentModel::where("id",$id)->findOrEmpty()->toArray();
        if(empty($comments)){
            throw new BaseException("您要查看的评价不存在",0);
        }

        $comments["images"] = !empty($comments["images"]) ? json_decode($comments["images"],true) : [];
        if(!empty($comments["images"])){
            $images = [];
            foreach($comments["images"] as $key=>$value){
                $images[$key] = Image::thumb($value);
            }

            $comments["images"] = $images;
        }

        return $comments;
    }

    /**
     * 保存
     * @param $params
     * @return true
     * @throws BaseException
     */
    public static function save($params=[]){
        $comments = UsersCommentModel::where("id",$params["id"]??0)->findOrEmpty()->toArray();
        if(empty($comments)){
            throw new BaseException("您要查看的评价不存在",0);
        }

        if(empty($params["reply_content"])){
            throw new BaseException("请填写回复内容",0);
        }

        UsersCommentModel::where("id",$params["id"])->save([
            "reply_content" => $params["reply_content"],
            "reply_status"  => 1,
            "reply_time"    => time()
        ]);

        return true;
    }

    /**
     * 删除评论
     * @param $id
     * @return true
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function delete($id){
        $comments = UsersCommentModel::where("id",$id)->find();
        if(empty($comments)){
            throw new BaseException("您要删除的评价不存在",0);
        }

        if(UsersCommentModel::where("id",$id)->delete()){
            $array = !empty($comments["images"]) ? json_decode($comments["images"],true) : [];
            foreach($array as $value){
                $path       = trim($value,"/");
                $thumbImage = Config::get("website.thumb_image",[]);
                $arr        = explode("/",$path);
                $lastImage  = end($arr);
                file_exists($path) && unlink($path);
                foreach($thumbImage as $key=>$val){
                    $thumb = str_replace($lastImage, $key . '_' . $lastImage, $path);
                    file_exists($thumb) && unlink($thumb);
                }
            }
        }

        return true;
    }

}