<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\shop;

use app\adminapi\model\shop\Brand as BrandModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;

/**
 * @package app\adminapi\service\shop
 * @class Brand
 * @author xzncit 2024-02-14
 */
class Brand {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = BrandModel::withSearch(...$fields)->count();
        $result          = BrandModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key]            = $value;
            $array["list"][$key]["photo"]   = Image::thumb($value["photo"]);
        }

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array = BrandModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        $array["photo"]   = !empty($array["photo"]) ? Image::thumb($array["photo"]) : "";
        $array["content"] = Image::replace(Image::removeAttribute($array["content"]),function($path,$content){
            return str_replace($path, Image::thumb($path), $content);
        });

        return $array;
    }

    /**
     * 保存
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        $params["photo"]   = Image::parseUrl($params["photo"]??"");
        $params["content"] = Image::replace($params["content"],function ($path,$content){
            return str_replace($path, Image::parseUrl($path), $content);
        });

        if(!empty($params["id"]) && BrandModel::where("id",$params["id"])->find()){
            BrandModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            BrandModel::create($params);
        }

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        BrandModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return BrandModel::where("id",$id)->delete();
    }

}