<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\promotion;

use app\common\model\promotion\Sign as SignModel;

/**
 * @package app\adminapi\service\promotion
 * @class Sign
 * @author xzncit 2024-02-18
 */
class Sign {

    /**
     * 获取
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail(){
        $array = SignModel::where("1=1")->find();
        if(!empty($array["list"])){
            $array["list"] = json_decode($array["list"],true);
        }

        return $array;
    }

    /**
     * 保存
     * @param array $params
     * @return bool|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params=[]){
        $row = SignModel::where("1=1")->find();
        if(!empty($params["list"])){
            $params["list"] = json_encode($params["list"],JSON_UNESCAPED_UNICODE);
        }

        if(empty($row)){
            $params["create_time"] = time();
            return SignModel::create($params)->id;
        }

        return SignModel::where("id",$row["id"])->save($params);
    }

}