<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\promotion;

use app\common\model\promotion\FreeShipping as FreeShippingModel;
use app\common\model\Region as RegionModel;
use app\common\library\utils\Data;

/**
 * @package app\adminapi\service\promotion
 * @class Shipping
 * @author xzncit 2024-02-19
 */
class Shipping {

    /**
     * 获取
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail(){
        $row = FreeShippingModel::where("1=1")->find();

        if(empty($row)){
            return [];
        }

        $row['area'] = [];
        if(!empty($row["area_group"])){
            $result = RegionModel::field("id,pid,name")->where("id","in",explode(",",$row["area_group"]))->select()->toArray();
            $row["area"] = Data::familyProcess($result);
        }

        return $row;
    }

    /**
     * 保存
     * @param array $params
     * @return bool|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params=[]){
        $row = FreeShippingModel::where("1=1")->find();
        if(empty($row)){
            $params["create_time"] = time();
            return FreeShippingModel::create($params)->id;
        }

        return FreeShippingModel::where("id",$row["id"])->save($params);
    }

}