<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\promotion;

use app\adminapi\model\promotion\Gift as GiftModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\common\model\goods\Goods as GoodsModel;

/**
 * @package app\adminapi\service\promotion
 * @class Gift
 * @author xzncit 2024-02-20
 */
class Gift {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = GiftModel::withSearch(...$fields)->count();
        $array["list"]   = GiftModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array = GiftModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        $array["goods"] = [];
        if(!empty($array["goods_list"])){
            $array["goods"] = GoodsModel::field("id,title,sell_price,store_nums,photo")->where("id","in",$array["goods_list"]??0)->orderRaw("FIELD(id,{$array["goods_list"]})")->select()->map(function ($res){
                $res["photo"] = Image::thumb($res["photo"]);
                return $res;
            });
        }

        $array["start_time"] = date("Y-m-d H:i:s",$array["start_time"]);
        $array["end_time"]   = date("Y-m-d H:i:s",$array["end_time"]);
        return $array;
    }

    /**
     * 保存
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        if(!empty($params["start_time"])) $params["start_time"] = strtotime($params["start_time"]);
        if(!empty($params["end_time"])) $params["end_time"] = strtotime($params["end_time"]);
        $params["goods_list"] = !empty($params["goods_id"]) ? implode(",",$params["goods_id"]) : '';
        if(!empty($params["id"]) && GiftModel::where("id",$params["id"])->find()){
            GiftModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            GiftModel::create($params);
        }

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        GiftModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return GiftModel::where("id",$id)->delete();
    }

}