<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\promotion;

use app\adminapi\model\promotion\Group as GroupModel;
use app\common\exception\BaseException;
use app\common\model\promotion\GroupGoods as GroupGoodsModel;
use app\adminapi\model\promotion\Games as GamesModel;
use app\common\model\promotion\GamesItem as GamesItemModel;
use app\common\library\utils\Image;

/**
 * @package app\adminapi\service\promotion
 * @class Games
 * @author xzncit 2024-02-21
 */
class Games {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = GamesModel::withSearch(...$fields)->count();
        $array["list"]   = GamesModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array  = GamesModel::where("id",$id)->find();
        if(empty($array)){
            return [];
        }

        $item = GamesItemModel::where("pid",$array["id"])->order('sort','asc')->select()->toArray();
        foreach($item as $key=>$value){
            $item[$key]["photo"] = Image::thumb($value["photo"]);
        }

        $array["list"] = $item;
        if(!empty($array["start_time"])) $array["start_time"] = date("Y-m-d H:i:s",$array["start_time"]);
        if(!empty($array["end_time"])) $array["end_time"]   = date("Y-m-d H:i:s",$array["end_time"]);
        return $array;
    }

    /**
     * 保存
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        GamesModel::transaction(function () use($params){
            if(!empty($params["start_time"])) $params["start_time"] = strtotime($params["start_time"]);
            if(!empty($params["end_time"])) $params["end_time"] = strtotime($params["end_time"]);
            if(!empty($params["id"]) && GamesModel::where("id",$params["id"])->find()){
                $params["update_time"] = time();
                GamesModel::where("id",$params["id"])->save($params);
            }else{
                $params["create_time"] = time();
                $params["id"] = GamesModel::create($params)->id;
            }

            $array = []; $i = 0;
            $params["item"] = $params["list"] ?? [];
            foreach($params["item"] as $key=>$value){
                $value["pid"]   = $params["id"];
                $value["sort"]  = $i;
                $value["photo"] = Image::parseUrl($value["photo"]);
                if(isset($value["id"]) && $value["id"] > 0){
                    $array[] = $value["id"];
                    GamesItemModel::where("id",$value["id"])->update($value);
                }else{
                    $array[] = GamesItemModel::withoutField("id")->insert($value,true);
                }

                $i++;
            }

            if(!empty($array)){
                GamesItemModel::where('pid',$params["id"])->where("id","not in",$array)->delete();
            }
        });

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        GamesModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        GamesModel::transaction(function () use($id){
            GamesModel::where("id",$id)->delete();
            GamesItemModel::where("pid",$id)->delete();
        });

        return true;
    }

}