<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\promotion;

use app\adminapi\model\promotion\Coupon as CouponModel;
use app\common\model\goods\Goods as GoodsModel;
use app\adminapi\model\users\UsersCoupon as UsersCouponModel;
use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\common\library\utils\Date;

/**
 * @package app\adminapi\service\promotion
 * @class Coupon
 * @author xzncit 2024-02-19
 */
class Coupon {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = CouponModel::withSearch(...$fields)->count();
        $array["list"]   = CouponModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        return $array;
    }

    public static function getReceive($params){
        $array           = [];
        $array["total"]  = UsersCouponModel::withJoin("coupon")->count();
        $array["list"]   = UsersCouponModel::withJoin("coupon")->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->map(function ($res){
            $res["username"] = getUserName($res["user_id"]);
            if($res["expire_type"] == 1){
                $res["days"] = $res["expire_day"];
            }else{
                $res["days"] = (int)Date::diff($res["start_time"],$res["end_time"]);
            }

            return $res;
        });
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array = CouponModel::where("id",$id)->find();
        if(empty($array)){
            return $array??[];
        }

        $array["goods"] = [];
        if(!empty($array["goods_list"])){
            $array["goods"] = GoodsModel::field("id,title,sell_price,store_nums,photo")->where("id","in",$array["goods_list"]??0)->orderRaw("FIELD(id,{$array["goods_list"]})")->select()->map(function ($res){
                $res["photo"] = Image::thumb($res["photo"]);
                return $res;
            });
        }

        $array["start_time"] = date("Y-m-d H:i:s",$array["start_time"]);
        $array["end_time"]   = date("Y-m-d H:i:s",$array["end_time"]);
        return $array;
    }

    /**
     * 保存
     * @param $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params){
        if(!empty($params["start_time"])) $params["start_time"] = strtotime($params["start_time"]);
        if(!empty($params["end_time"])) $params["end_time"] = strtotime($params["end_time"]);
        if($params["apply_range"] != 0){
            $params["goods_list"] = !empty($params["goods_id"]) ? implode(",",$params["goods_id"]) : '';
        }else{
            $params["goods_list"] = '';
        }

        if(!empty($params["id"]) && CouponModel::where("id",$params["id"])->find()){
            CouponModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            CouponModel::create($params);
        }

        return true;
    }

    /**
     * 修改状态
     * @param $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params){
        if(!in_array($params["type"],["status"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        CouponModel::where("id",$params["id"]??0)->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return CouponModel::where("id",$id)->delete();
    }

}