<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\order;

use app\common\exception\BaseException;
use think\facade\Request;
use app\common\service\Config;
use app\adminapi\model\order\Order as OrderModel;
use app\common\model\order\OrderGoods as OrderGoodsModel;
use app\common\model\order\OrderAddress as OrderAddressModel;
use app\common\library\http\printer\xpyun\Xpyun;
use app\common\library\http\printer\xpyun\XpyunException;

/**
 * @package app\adminapi\service\order
 * @class Printing
 * @author xzncit 2024-02-26
 */
class Printing {

    public static function cart($id){
        return self::getOrderInfo($id);
    }

    public static function distribution($id){
        return self::getOrderInfo($id);
    }

    public static function detail($id){
        return self::getOrderInfo($id);
    }

    public static function getOrderInfo($id){
        $row = OrderModel::where("id",$id)->find();
        if(empty($row)){
            throw new \Exception("您要查找的订单不存在",0);
        }

        $row["goods"] = OrderGoodsModel::where("order_id",$id)->select()->map(function ($res){
            $spec = [];
            if(!empty($res["goods_array"])){
                $spec = json_decode($res["goods_array"],true);
            }

            $res["spec"] = $spec;
            return $res;
        });

        $address            = OrderAddressModel::where("order_id",$id)->find();
        $row["accept_name"] = $address["accept_name"]??"";
        $row["mobile"]      = $address["mobile"]??"";
        $row["address"]     = implode(",",array_map(function ($res){ if(!empty($res)){ return $res; } },[$address["province"]??"",$address["city"]??"",$address["area"]??"",$address["address"]??""]));
        $row["config"]      = Config::getArray("website",[]);
        return $row;
    }

    public static function ticket($id){
        $deviceSn = Config::getArray("printer.xpyun.device_id");
        if(empty($deviceSn)){
            throw new BaseException("请配置小票打印机",0);
        }

        $xpyun = new Xpyun();
        $statusResult = $xpyun->queryPrinterStatus($deviceSn);

        if($statusResult["data"] == 0){
            throw new BaseException("打印机离线中",0);
        }else if($statusResult["data"] == 2){
            throw new BaseException("打印机异常，查看打印机是否缺纸",0);
        }

        $order = self::getOrderInfo($id);

        $content = "<IMG></IMG>
<CB>--订单小票--
<BR>
<L><N>下单时间:".date('Y年m月d日H时i分',$order['create_time'])."
订单编号:".$order['order_no']."
**************商品**************";
foreach($order["goods"] as $value){
    $content .= "<L><N>".$value["goods_name"] . " " . ($value["spec"]["name"]??"") . " x".$value['goods_total_nums']." " . $value["sell_price"];
}
$content .= "
--------------------------------
配送运费:￥".$order['real_freight']."
优惠券:￥".$order['coupon_amount']."
订单折扣:￥".$order['discount']."
<L><N>********************************
订单总价:￥".$order['order_amount']."
<N>" . $order['address'] . "
".$order['accept_name'].":".$order['mobile']."
订单备注：".($order['message']??'-')."
<C><HB>二维码
<L><QRCODE s=6 e=L l=center>".Request::domain()."/mobile"."</QRCODE>";

        $result = $xpyun->print($deviceSn,$content);
        if($result["code"] != 0){
            throw new BaseException(XpyunException::getMessage($result["code"]),0);
        }

        return true;
    }

}