<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\order;

use app\adminapi\service\order\Order as OrderService;
use app\adminapi\model\order\OrderInvoice as OrderInvoiceModel;
use app\common\enum\OrderInvoice;
use app\common\enum\Order;

/**
 * @package app\adminapi\service\order
 * @class Invoice
 * @author xzncit 2024-02-27
 */
class Invoice {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $array["total"]  = OrderInvoiceModel::withJoin("orders")->count();
        $result          = OrderInvoiceModel::withJoin("orders")->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->map(function ($res){
            $res["invoice_header_type"] = OrderInvoice::headerType($res["header_type"]);
            $res["invoice_type"] = OrderInvoice::type($res["type"]);
            $res["invoice_status"] = OrderInvoice::status($res["status"]);
            $res["text"] = Order::activeText(Order::active($res["orders"]));
            return $res;
        });

        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key] = $value;
        }

        return $array;
    }

    /**
     * 保存
     * @param array $params
     * @return bool
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($params=[]){
        $row = OrderInvoiceModel::where("id",$params['id'])->find();
        if(empty($row)){
            throw new \Exception("您要查找的内容不存在",0);
        }

        OrderInvoiceModel::where("id",$params['id'])->save([
            "status"=>$params["status"],
            "update_time"=>time()
        ]);
        return true;
    }

    /**
     * 详情
     * @param $id
     * @return array|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $row = OrderInvoiceModel::where("id",$id)->find();
        if(empty($row)){
            throw new \Exception("您要查找的内容不存在",0);
        }

        $order                          = OrderService::detail($row["order_id"]);
        $order["invoice_header_type"]   = OrderInvoice::headerType($row["header_type"]);
        $order["invoice_type"]          = OrderInvoice::type($row["type"]);
        $order["invoice_name"]          = $row["name"];
        $order["invoice_duty_number"]   = $row["duty_number"];
        $order["invoice_drawer_phone"]   = $row["drawer_phone"];
        $order["invoice_email"]         = $row["email"];
        $order["invoice_tell"]          = $row["tell"];
        $order["invoice_address"]       = $row["address"];
        $order["invoice_bank"]          = $row["bank"];
        $order["invoice_card_number"]   = $row["card_number"];
        $order["invoice_status"]        = OrderInvoice::status($row["status"]);
        $order["invoice"]               = $row;
        return $order;
    }

}