<?php

namespace app\adminapi\service\diy;

use app\adminapi\model\Archives as ArchivesModel;
use app\adminapi\model\diy\LayoutPage as LayoutPageModel;

/**
 * @package app\adminapi\service\diy
 * @class Topic
 * @author xzncit 2024/3/29
 */
class Topic {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = LayoutPageModel::withSearch(...$fields)->where("page_type",2)->count();
        $result          = LayoutPageModel::withSearch(...$fields)->where("page_type",2)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key]            = $value;
        }

        return $array;
    }

    public static function detail($id){
        $array = LayoutPageModel::where("id",$id)->findOrEmpty()->toArray();
        if(empty($array)){
            return $array??[];
        }

        return $array;
    }

    public static function save($params){
        if(!empty($params["id"]) && LayoutPageModel::where("id",$params["id"])->find()){
            $params["update_time"] = time();
            LayoutPageModel::where("id",$params["id"])->save($params);
        }else{
            $params["create_time"] = time();
            $params["update_time"] = time();
            $params["page_type"]   = 2;
            LayoutPageModel::create($params);
        }

        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return LayoutPageModel::where("id",$id)->delete();
    }

}