<?php

namespace app\adminapi\service\diy;

use app\common\exception\BaseException;
use app\common\library\utils\Image;
use app\common\model\diy\LayoutTemplate as LayoutTemplateModel;
use app\common\model\diy\LayoutPage as LayoutPageModel;

/**
 * @package app\adminapi\service\diy
 * @class Template
 * @author xzncit 2024/3/28
 */
class Template {

    /**
     * 列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList(){
        $array           = [];
        $array["total"]  = LayoutTemplateModel::count();
        $result          = LayoutTemplateModel::order("id","desc")->select()->toArray();
        $array["list"]   = [];
        foreach($result as $key=>$value){
            $array["list"][$key]            = $value;
            $array["list"][$key]["photo"]   = Image::thumb($value["photo"]);
        }

        return $array;
    }

    /**
     * 启用主题
     * @param $id
     * @return true
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($id){
        $template = LayoutTemplateModel::where("id",$id)->find();
        if(empty($template)){
            throw new BaseException("主题不存在",0);
        }

        LayoutPageModel::where("type","home")->save([
            "content"=>$template["content"],
            "setting"=>$template["setting"],
            "update_time"=>time()
        ]);

        return true;
    }

}