<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service\diy;

use app\common\model\diy\LayoutPage as LayoutPageModel;
use app\common\library\utils\Image;

/**
 * @package app\adminapi\service\diy
 * @class Layout
 * @author xzncit 2023-11-26
 */
class Layout {

    /**
     * 获取装修数据
     * @param array $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getLayout($params=[]){
        $condition = [];
        if(is_numeric($params["id"])){
            $condition[] = ["id","=",intval($params["id"]??0)];
            $condition[] = ["page_type","=","2"];
        }else{
            $condition[] = ["type","=",trim($params["id"])];
            $condition[] = ["page_type","=","1"];
        }

        $array = LayoutPageModel::where($condition)->find();
        $result = !empty($array["content"]) ? json_decode($array["content"],true) : [];
        $setting = !empty($array["setting"]) ? json_decode($array["setting"],true) : [];
        foreach($result as $key=>&$item){
            $item["icon"] = Image::thumb(Image::parseUrl($item["icon"]));
            if(empty($item["value"])){
                continue;
            }

            if(!empty($item["value"]["list"])){
                foreach($item["value"]["list"] as $k=>$v){
                    if(!empty($v["image"])){
                        $item["value"]["list"][$k]["image"] = Image::thumb(Image::parseUrl($v["image"]));
                    }
                }
            }

            if(!empty($item["value"]["goods"])){
                foreach($item["value"]["goods"] as $k=>$v){
                    if(!empty($v["image"])){
                        $item["value"]["goods"][$k]["image"] = Image::thumb(Image::parseUrl($v["image"]));
                    }
                }
            }
        }

        if(!empty($setting["value"]["list"])){
            foreach($setting["value"]["list"] as $k=>$v){
                if(!empty($v["image"])){
                    $item["value"]["list"][$k]["image"] = Image::thumb(Image::parseUrl($v["image"]));
                }
            }
        }

        return [
            "title" => $array["name"],
            "value" => $result,
            "setting" => $setting
        ];
    }

    /**
     * 保存装修数据
     * @param array $params
     * @return bool
     */
    public static function saveLayout($params=[]){
        $data = $params["data"]??[];
        $setting = $params["setting"]??[];

        $condition = [];
        if(is_numeric($params["id"])){
            $condition[] = ["id","=",intval($params["id"]??0)];
            $condition[] = ["page_type","=","2"];
        }else{
            $condition[] = ["type","=",trim($params["id"])];
            $condition[] = ["page_type","=","1"];
        }

        return LayoutPageModel::where($condition)->save([
            "setting"       => (!empty($setting) ? json_encode($setting,JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK) : ''),
            "content"       => (!empty($data) ? json_encode($data,JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK) : ''),
            "update_time"   => time()
        ]);
    }

    /**
     * 保存数据
     * @param array $data
     * @param array $condition
     * @return bool
     */
    public static function setData($data=[],$condition=[]){
        return LayoutPageModel::where($condition)->save($data);
    }

    /**
     * 获取数据
     * @param array $condition
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getData($condition=[]){
        $row = LayoutPageModel::where($condition)->find();
        return [
            "name"  => $row["name"]??"",
            "time"  => empty($row["update_time"]) ? $row["create_time"] : $row["update_time"]
        ];
    }
    
}