<?php

namespace app\adminapi\service\chat;

use app\adminapi\model\Admin as AdminModel;
use app\common\exception\BaseException;
use app\common\library\utils\Hash;
use app\common\library\utils\Image;
use app\common\library\utils\Tool;
use app\adminapi\model\chat\ChatUsers as ChatUsersModel;
use app\common\service\Config as ConfigService;
use think\facade\Request;

/**
 * @package app\adminapi\service\chat
 * @class Online
 * @author xzncit 2024/3/30
 */
class Online {

    /**
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = ["title",["title"=>$params["keywords"]??'']];
        $array["total"]  = ChatUsersModel::withSearch(...$fields)->count();
        $array["list"]   = ChatUsersModel::withSearch(...$fields)->order("id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array = ChatUsersModel::where("id",$id??0)->findOrEmpty()->toArray();
        if(!empty($array)){
            $array["password"] = "";
            $array["confirm_password"] = "";
        }

        return $array;
    }

    /**
     * 添加/修改
     * @param $data
     * @return AdminModel|bool|\think\Model
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function save($data){
        if(empty($data["id"])){
            if(empty($data["password"])){
                throw new BaseException("请填写密码",0);
            }else if(empty($data["confirm_password"])){
                throw new BaseException("请填写确认密码",0);
            }else if($data["password"] != $data["confirm_password"]){
                throw new BaseException("您输入的两次密码不致。",0);
            }

            if(ChatUsersModel::where("username",$data["username"])->count()){
                throw new BaseException("用户名已存在",0);
            }

            $data["salt"]        = Tool::getRands(5);
            $data["password"]    = Hash::md5($data["password"],$data["salt"]);
            $data["create_time"] = time();
            $data["update_time"] = time();
            $data["online_time"] = time();
            return ChatUsersModel::create($data);
        }

        $user = ChatUsersModel::where("id",$data["id"])->find();
        if(empty($user)){
            throw new BaseException("您要修改的内容不存在",0);
        }

        $oldUser = ChatUsersModel::where("username",$data["username"])->find();
        if(!empty($oldUser) && $user["id"] != $oldUser["id"]){
            throw new BaseException("用户名已存在",0);
        }

        if(!empty($data["password"]) || !empty($data["confirm_password"])){
            if($data["password"] != $data["confirm_password"]){
                throw new \Exception("您输入的两次密码不致。",0);
            }

            $data["salt"]        = Tool::getRands(5);
            $data["password"]    = Hash::md5($data["password"],$data["salt"]);
            return ChatUsersModel::where("id",$data["id"])->save($data);
        }

        return ChatUsersModel::where("id",$data["id"])->withoutField(["password","confirm_password"])->save($data);
    }

    /**
     * 删除
     * @param $id
     * @return bool
     * @throws BaseException
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function delete($id){
        $row = ChatUsersModel::where("id",$id)->find();
        if(empty($row)){
            throw new BaseException("您要查找的内容不存在",0);
        }

        return ChatUsersModel::where("id",$id)->delete();
    }

    /**
     * 人工客服
     * @param $data
     * @return array|bool|mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function customer($data){
        if(Request::isGet()){
            $array                      = ConfigService::getArray("customer");
            $array["qrcode"]            = Image::avatar($array["qrcode"]);
            return $array;
        }

        $data["qrcode"] = Image::parseUrl($data["qrcode"]);
        return ConfigService::save("customer",$data);
    }

    /**
     * 客服设置
     * @param $data
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function setting($data){
        if(Request::isGet()){
            return ConfigService::getArray("socket");
        }

        return ConfigService::save("socket",$data);
    }

}