<?php

namespace app\adminapi\service;

use app\common\library\utils\Image;
use app\common\exception\BaseException;
use app\adminapi\model\WithdrawTerminal as WithdrawTerminalModel;

/**
 * @package app\adminapi\service
 * @class WithdrawTerminal
 * @author xzncit 2024/4/13
 */
class WithdrawTerminal {

    /**
     * 支付方式
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList(){
        $result = WithdrawTerminalModel::withJoin(["payment"=>["name","photo"]])->where("withdraw_terminal.terminal","<>",8)->where("payment.code","<>","balance")->order("payment.sort","ASC")->select()->toArray();

        $array  = [];
        foreach($result as $value){
            $value["photo"] = Image::thumb($value["photo"]);
            $array[$value["terminal"]][] = $value;
        }

        return $array;
    }

    /**
     * 修改字段状态
     * @param array $params
     * @return bool
     * @throws BaseException
     */
    public static function status($params=[]){
        if(!in_array($params["type"],["status","is_default"])){
            throw new BaseException("error status",0);
        }

        $data = [ $params["type"]=>intval($params["value"]??0) ];
        if($params["type"] == "status"){
            WithdrawTerminalModel::where("id",$params["id"]??0)->update($data);
        }else{
            $row = WithdrawTerminalModel::where("id",$params["id"]??0)->find();
            WithdrawTerminalModel::where("terminal",$row["terminal"])->update(["is_default"=>0]);
            WithdrawTerminalModel::where("id",$params["id"]??0)->update($data);
        }

        return true;
    }

}