<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use think\facade\Request;
use app\adminapi\model\Users as UsersModel;
use app\common\exception\BaseException;
use app\common\library\utils\Hash;
use app\common\library\utils\Tool;
use app\common\model\UsersGroup as UsersGroupModel;
use app\common\library\utils\Image;
use app\common\service\Config as ConfigService;

/**
 * @package app\adminapi\service
 * @class Users
 * @author xzncit 2023-09-05
 */
class Users {

    /**
     * 列表
     * @param $params
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getList($params){
        $array           = [];
        $fields          = [
            ["username","active"],
            [
                "username"  => $params["keywords"]??"",
                "active"    => $params["active"]??0
            ]
        ];

        $array["list"]   = [];
        $array["total"]  = UsersModel::withSearch(...$fields)->withJoin("group")->count();
        $result          = UsersModel::withSearch(...$fields)->withJoin("group")->order("users.id","desc")->page($params["current"]??1,$params["size"]??10)->select()->toArray();
        foreach($result as $key=>$value){
            $array["list"][$key]           = $value;
            $array["list"][$key]["avatar"] = Image::avatar($value["avatar"]);
        }

        $array["count"] = [
            "0" => UsersModel::count(),
            "1" => UsersModel::where(["status"=>1])->count(),
            "2" => UsersModel::where(["status"=>2])->count(),
            "3" => UsersModel::where(["status"=>3])->count(),
            "4" => UsersModel::where(["status"=>4])->count()
        ];

        return $array;
    }

    /**
     * 详情
     * @param $id
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function detail($id){
        $array          = [];
        $array["group"] = UsersGroupModel::order('sort','ASC')->select()->toArray();
        $array["users"] = UsersModel::withoutField("password")->where("id",$id)->find();
        return $array;
    }

    public static function save($data){
        if(empty($data["id"])){
            if(empty($data["password"])){
                throw new BaseException("请填写密码",0);
            }else if(empty($data["confirm_password"])){
                throw new BaseException("请填写确认密码",0);
            }else if($data["password"] != $data["confirm_password"]){
                throw new BaseException("您输入的两次密码不致。",0);
            }

            $data["create_time"]    = time();
            $data["update_time"]    = time();
            $data["join_time"]      = time();
            $data["salt"]           = Tool::getRands(5);
            $data["password"]       = Hash::md5($data["password"],$data["salt"]);
            UsersModel::create($data);
            return true;
        }

        if(!empty($data["password"]) || !empty($data["confirm_password"])){
            if($data["password"] != $data["confirm_password"]){
                throw new BaseException("您输入的两次密码不致。",0);
            }

            $data["salt"]       = Tool::getRands(5);
            $data["password"]   = Hash::md5($data["password"],$data["salt"]);
        }else{
            unset($data['password'],$data['confirm_password']);
        }

        $data["update_time"] = time();
        UsersModel::where("id",$data["id"])->save($data);
        return true;
    }

    /**
     * 删除
     * @param $id
     * @return bool
     */
    public static function delete($id){
        return UsersModel::where("id",$id)->delete();
    }

    public static function setting($data){
        if(Request::isGet()){
            $array                      = ConfigService::getArray("users");
            $array["avatar"]            = Image::avatar($array["avatar"]);
            return $array;
        }

        $data["avatar"] = Image::parseUrl($data["avatar"]);
        return ConfigService::save("users",$data);
    }

}