<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\common\library\utils\Image;
use think\facade\Request;
use xzncit\OSS;
use app\common\service\Config as ConfigService;

/**
 * @package app\adminapi\service
 * @class System
 * @author xzncit 2024-02-19
 */
class System {

    /**
     * 上传设置
     * @param $params
     * @return array|bool
     * @throws \think\db\exception\DbException
     */
    public static function upload($params){
        if(Request::isGet()){
            return [
                "upload" => ConfigService::getArray("upload"),
                "city"   => [
                    "aliyuncs" => [
                        "city" => OSS::config("aliyuncs")["city"]
                    ],
                    "qcloud" => [
                        "city" => OSS::config("qcloud")["city"]
                    ]
                ]
            ];
        }

        return ConfigService::save($params);
    }

    /**
     * 邮箱
     * @param $params
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function email($params){
        if(Request::isGet()){
            return ConfigService::getArray("email",[
                "address"=> '',
                "port"=> '',
                "username"=> '',
                "password"=> '',
                "smtp_name"=> '',
                "smtp_send"=> '',
                "is_ssl"=> '1'
            ]);
        }

        return ConfigService::save($params);
    }

    /**
     * 备案信息
     * @param $params
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function copy($params){
        if(Request::isGet()){
            return ConfigService::getArray("copy");
        }

        return ConfigService::save($params);
    }

    /**
     * 店铺设置
     * @param $params
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function shopSetting($params){
        if(Request::isGet()){
            return ConfigService::getArray("website");
        }

        return ConfigService::save($params);
    }

    /**
     * 获取/保存协议
     * @param $params
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function saveAgree($params,$key){
        if(Request::isGet()){
            $params["content"] = Image::replace(Image::removeAttribute($params["content"]),function($path,$content){
                return str_replace($path, Image::thumb($path), $content);
            });

            return ConfigService::getArray($key);
        }

        $params["content"] = Image::replace($params["content"],function ($path,$content){
            return str_replace($path, Image::parseUrl($path), $content);
        });

        return ConfigService::save($params,$key);
    }

    /**
     * 获取/保存关键字
     * @param $params
     * @return array|bool|mixed|null
     * @throws \think\db\exception\DbException
     */
    public static function savekeywords($params){
        if(Request::isGet()){
            return ConfigService::getString("keywords");
        }

        return ConfigService::save("keywords",$params["keywords"]??"");
    }

}