<?php
// +----------------------------------------------------------------------
// | A3Mall
// +----------------------------------------------------------------------
// | Copyright (c) 2020 http://www.a3-mall.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: xzncit <158373108@qq.com>
// +----------------------------------------------------------------------

namespace app\adminapi\service;

use app\adminapi\service\Chart as ChartService;
use app\common\model\Users as UsersModel;
use app\common\model\goods\Goods as GoodsModel;
use app\common\model\order\Order as OrderModel;
use app\common\model\order\OrderRefunds as OrderRefundsModel;
use app\common\model\statistics\StatisticsSearch as StatisticsSearchModel;
use app\common\model\order\OrderInvoice as OrderInvoiceModel;

/**
 * @package app\adminapi\service
 * @class Statistic
 * @author xzncit 2024-02-19
 */
class Statistic {

    /**
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function getData(){
        $array = [];

        // 本季时间
        $startTime = strtotime(date("Y-m-d 00:00:00",time()));
        $endTime   = strtotime(date("Y-m-d 23:59:59",time()));

        // 本季用户数量
        $array["users_quarter_count"] = UsersModel::whereTime("create_time",">=",$startTime - 3600 * 24 * 90)
            ->whereTime("create_time","<=",$endTime - 3600 * 24 * 90)->count();

        // 今日新增用户
        $array["users_day_count"] = $array["users_quarter_count"] = UsersModel::whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)->count();

        // 本周新增用户
        $array["users_week_count"] = $array["users_quarter_count"] = UsersModel::whereTime("create_time",">=",$startTime - 3600 * 24 * 7)
            ->whereTime("create_time","<=",$endTime)->count();

        $array["users_charts"] = ChartService::getUsers();

        // 本季总采购额
        $array["order_quarter_sum"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime - 3600 * 24 * 90)
            ->whereTime("create_time","<=",$endTime)->sum("order_amount");

        // 今日总采购额
        $array["order_day_sum"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)->sum("order_amount");

        // 本周总采购额
        $array["order_week_sum"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime - 3600 * 24 * 7)
            ->whereTime("create_time","<=",$endTime)->sum("order_amount");

        $array["order_charts"] = ChartService::getOrderAmount();

        // 本季订单数量
        $array["order_quarter_count"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime - 3600 * 24 * 90)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 今日订单数量
        $array["order_day_count"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 本周订单数量
        $array["order_week_count"] = OrderModel::where("status",6)
            ->whereTime("create_time",">=",$startTime - 3600 * 24 * 7)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        $array["order_charts_total"] = ChartService::getOrderCount();

        $array["goods"] = GoodsModel::where("status",0)->order("sale","desc")->limit(5)->select()->toArray();
        $array["search"] = StatisticsSearchModel::order("num","desc")->select()->toArray();
        return $array;
    }


    public static function getOrder($params=[]){
        $start  = empty($params["time"][0]) ? strtotime("-7 day") : $params["time"][0] / 1000;
        $end    = empty($params["time"][1]) ? time() : $params["time"][1] / 1000;

        if($start >= $end){
            $start = strtotime("-7 day");
            $end   = time();
        }

        $startTime = strtotime(date("Y-m-d 00:00:00",$start));
        $endTime   = strtotime(date("Y-m-d 23:59:59",$end));

        $array = [];
        $array["chart"] = ChartService::getOrderTotal($startTime,$endTime);

        // 订单数
        $array["order_count"] = OrderModel::where("status","not in","1,7,8")
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 支付金额
        $array["order_amount"] = OrderModel::where("status","in","3,4,5,6")
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->sum("order_amount");

        // 支付订单
        $array["order_price"] = OrderModel::where("status","in","3,4,5,6")
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 待发货订单
        $array["order_distribution"] = OrderModel::where("status","in","3")
            ->where("delivery_status",0)
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 未开发票
        $array["order_invoice"] = OrderInvoiceModel::where("status","=",1)
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        // 退款订单
        $array["order_refundment_count"] = OrderRefundsModel::where("status",1)
            ->whereTime("create_time",">=",$startTime)
            ->whereTime("create_time","<=",$endTime)
            ->count();

        return $array;
    }

}